﻿#pragma once

#if       !defined(INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK)
#include  <szArchiveOpenClientCallback.hpp>
#endif // !defined(INCLUDED_SZ_ARCHIVE_OPEN_CLIENT_CALLBACK)

#if       !defined(INCLUDED_SZ_ARCHIVE_FILE_EXTRACT_CLIENT_CALLBACK)
#include  <szArchiveFileExtractClientCallback.hpp>
#endif // !defined(INCLUDED_SZ_ARCHIVE_FILE_EXTRACT_CLIENT_CALLBACK)

#if       !defined(INCLUDED_SZ_GET_PASSWORD_CLIENT_CALLBACK)
#include  <szGetPasswordClientCallback.hpp>
#endif // !defined(INCLUDED_SZ_GET_PASSWORD_CLIENT_CALLBACK)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

class CommandProcessorState;
class ProcessUI;

class Decompressor :
  public szpp::ArchiveOpenClientCallback,
  public szpp::ArchiveFileExtractClientCallback,
  public szpp::GetPasswordClientCallback
{
public:

  Decompressor(const szstring &archivePath, CommandProcessorState *pState, ProcessUI *pUI);
  ~Decompressor();

  /// アーカイブを列挙して展開の準備をする。続行できないエラーが起きれば例外を送出。
  void Open();

  /// SevenZip++ の簡易展開機能を使って展開する。
  void Decompress();

  // ArchiveOpenClientCallback
  virtual HRESULT SetTotal(const u64 &files, const u64 &bytes);
  virtual HRESULT SetCompleted(const u64 &files, const u64 &bytes);

  // GetPasswordClientCallback
  virtual HRESULT GetPassword(szstring *password);

  // ArchiveFileExtractClientCallback
  virtual HRESULT SetTotal(const u64 &total);
  virtual HRESULT SetCompleted(const u64 &completeValue);
  virtual HRESULT CryptoGetTextPassword(szstring *password);
  virtual HRESULT AskOverwrite(
    const szstring &existingName, const szpp::Time &existingTime, const u64 &existingSize,
    const szstring &newName, const szpp::Time &newTime, const u64 &newSize,
    u32 *answer);
  virtual HRESULT PrepareOperation(const szstring &name, bool isFolder, u32 extractMode, const u64 &position);
  virtual HRESULT MessageError(const szstring &message);
  virtual HRESULT SetOperationResult(u32 operationResult, bool encrypted);
  virtual HRESULT BeforeOpen(const szstring &name);
  virtual HRESULT OpenResult(const szstring &name, HRESULT result, bool encrypted);
  virtual HRESULT ThereAreNoFiles();
  virtual HRESULT ExtractResult(HRESULT result);
  virtual HRESULT SetPassword(const szstring &password);

private:

  void DecompressGzip(const szstring &srcPath, const szstring &dstPath);
  void DecompressBzip2(const szstring &srcPath, const szstring &dstPath);
  void PreprocessTar();

  HRESULT CheckQuitAndReturn();
  void ThrowIfCanceled();
  
  szstring archivePath;
  szstring virtualPath; // 実体はテンポラリに展開されている tar ファイルの仮想パス
  szstring realPath; // テンポラリディレクトリなどに一時展開される tar ファイルのパス
  szstring password;
  CommandProcessorState *pState;
  ProcessUI *pUI;
  szpp::ArchiveHandler *archiveHandler;
  std::auto_ptr<szpp::ArchiveContent> archiveContent;
  bool skipAll;
  bool canceled;
};
